/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.sivir;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.PlayerCreatureEntity;
import entities.creatures.enemies.SivirEntity;
import entities.missiles.MissileEntity;
import java.util.Random;
import util.Config;
import util.ResourceManager;

public final class SivirShotEntity
extends MissileEntity {
    private long lastFrameChange;
    private Random random = new Random();
    private boolean used = false;

    public SivirShotEntity(SivirEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/sivir/shot", x, y);
        this.moveSpeed = Config.get(Config.sivirShotProjectileSpeed);
        switch (game.getDifficulty()) {
            case HARD: 
            case LEGENDARY: {
                this.dy = Math.max(this.random.nextDouble() * this.moveSpeed, this.moveSpeed);
                this.dx = this.random.nextDouble() * this.dy;
                if (this.random.nextBoolean()) {
                    this.dx = -this.dx;
                }
                if (!this.random.nextBoolean()) break;
                this.dy = -this.dy;
                break;
            }
            default: {
                this.dy = Math.max(this.random.nextDouble() * this.moveSpeed, this.moveSpeed);
                this.dx = this.random.nextDouble() * (this.dy / 2.0);
            }
        }
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        this.lastFrameChange += delta;
        if (this.lastFrameChange > 5L) {
            this.lastFrameChange = 0L;
            this.sprite.rotate(10.0f);
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (this.used) {
            return;
        }
        if (other instanceof PlayerCreatureEntity) {
            this.game.removeEntity(this);
            ResourceManager.get().playSound("sivir_shot_hit");
            ((CreatureEntity)other).damage(this, Config.get(Config.sivirShotDamage));
            this.parent.addMoveSpeedMultiplier(Config.get(Config.sivirPassiveMoveSpeedMultiplier), this.game.getTime() + (long)Config.get(Config.sivirPassiveDuration));
            this.used = true;
        }
    }
}

